/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.screen;

import com.google.common.base.Charsets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.screen.QuickShareScreen;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.betterstats.util.io.BetterStatsWebApiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UIListLayout;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TStackTracePanel;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.Axis2D;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.enumerations.VerticalAlignment;
import io.github.thecsdev.tcdcommons.api.util.io.HttpUtils;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResource;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResourceManager;
import io.github.thecsdev.tcdcommons.api.util.io.cache.IResourceFetchTask;
import io.github.thecsdev.tcdcommons.api.util.math.Tuple2;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import net.minecraft.class_124;
import net.minecraft.class_1255;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class QuickShareUploadScreen
extends QuickShareScreen {
    private static final String CRLF = "\r\n";
    @ApiStatus.Internal
    private volatile boolean __started = false;
    @ApiStatus.Internal
    private volatile int __stage = 0;
    @ApiStatus.Internal
    private volatile Throwable __error = null;
    @ApiStatus.Internal
    private volatile String __quickShareCode = null;
    private final IStatsProvider stats;

    public QuickShareUploadScreen(@Nullable class_437 parent, IStatsProvider stats) throws NullPointerException {
        super(parent, (class_2561)BST.gui_qsscreen_upload_title());
        this.stats = Objects.requireNonNull(stats);
    }

    protected final void init() {
        this.__start__stage1();
        TLabelElement lbl = new TLabelElement(0, 0, this.getWidth(), this.getHeight());
        lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        lbl.setTextColor(-256);
        this.addChild((TElement)lbl, false);
        switch (this.__stage) {
            case -1: {
                this.removeChild((TElement)lbl, false);
                int w = (int)((float)this.getWidth() * 0.6f);
                if (w < 300) {
                    w = 300;
                }
                if (w > this.getWidth()) {
                    w = this.getWidth();
                }
                TStackTracePanel panel_st = new TStackTracePanel(0, 0, w, this.getHeight() - 50, this.__error);
                panel_st.setCloseAction(() -> this.close());
                panel_st.setTitle(BST.gui_qsscreen_upload_stageN1().getString());
                panel_st.setDescription(this.__error.getMessage());
                this.addChild((TElement)panel_st, false);
                new UIListLayout(Axis2D.Y, VerticalAlignment.CENTER, HorizontalAlignment.CENTER).apply((TParentElement)this);
                break;
            }
            case 0: {
                lbl.setText((class_2561)BST.gui_qsscreen_upload_stage0());
                break;
            }
            case 1: {
                lbl.setText((class_2561)BST.gui_qsscreen_upload_stage1());
                break;
            }
            case 2: {
                lbl.setText((class_2561)BST.gui_qsscreen_upload_stage2());
                break;
            }
            case 3: {
                lbl.setText((class_2561)BST.gui_qsscreen_upload_stage3());
                break;
            }
            case 4: {
                String codeStr = StringUtils.removeEnd((String)this.__quickShareCode, (String)QSC_SUFFIX).toUpperCase(Locale.ENGLISH);
                class_5250 codeTxt = TextUtils.literal((String)codeStr).method_27692(class_124.field_1068);
                lbl.setText((class_2561)BST.gui_qsscreen_upload_stage4((class_2561)codeTxt));
                TButtonWidget btn_done = new TButtonWidget(this.getWidth() / 2 - 75, this.getHeight() - 30, 150, 20);
                btn_done.setText((class_2561)TextUtils.translatable((String)"gui.done", (Object[])new Object[0]));
                btn_done.setOnClick(__ -> this.close());
                this.addChild((TElement)btn_done, false);
                break;
            }
        }
    }

    @ApiStatus.Internal
    private void __start_onError(@Nullable Exception exception) {
        this.__stage = -1;
        this.__error = exception;
        if (!this.isOpen()) {
            return;
        }
        this.refresh();
        BetterStats.LOGGER.error("[Quick-share] Failed to upload quick-share statistics." + (String)(this.__quickShareCode != null ? " The quick-share code is: " + this.__quickShareCode : ""), (Throwable)exception);
    }

    @ApiStatus.Internal
    private void __start__stage1() {
        if (this.__started) {
            return;
        }
        this.__started = true;
        this.__stage = 1;
        if (!this.isOpen()) {
            return;
        }
        BetterStats.LOGGER.info("[Quick-share] Uploading quick-share statistics...");
        BetterStatsWebApiUtils.fetchBssApiLinksAsync(BetterStatsClient.MC_CLIENT, json -> this.__start__stage2((JsonObject)json), error -> {
            if (error instanceof HttpResponseException) {
                HttpResponseException hre = (HttpResponseException)error;
                String msg = "HTTP " + hre.getStatusCode() + " " + hre.getReasonPhrase();
                String txt = BST.gui_qsscreen_err_cmmn_fau_httpN200(msg).getString();
                this.__start_onError(new IOException(txt, (Throwable)error));
            } else {
                String txt = BST.gui_qsscreen_err_cmmn_fau_generic().getString();
                this.__start_onError(new IOException(txt, (Throwable)error));
            }
        });
    }

    @ApiStatus.Internal
    private void __start__stage2(final JsonObject links) {
        this.__stage = 2;
        if (!this.isOpen()) {
            return;
        }
        this.refresh();
        CachedResourceManager.getResourceAsync((class_2960)class_2960.method_60655((String)BetterStats.getModID(), (String)"quick_share/latest_upload_url.json"), (IResourceFetchTask)new IResourceFetchTask<JsonObject>(){

            public class_1255<?> getMinecraftClientOrServer() {
                return BetterStatsClient.MC_CLIENT;
            }

            public Class<JsonObject> getResourceType() {
                return JsonObject.class;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CachedResource<JsonObject> fetchResourceSync() throws Exception {
                String endpoint = null;
                try {
                    endpoint = links.get("quickshare_guu").getAsString();
                }
                catch (Exception e) {
                    String additionalNote = "-";
                    if (links.has("quickshare_notice") && links.get("quickshare_notice").isJsonPrimitive()) {
                        additionalNote = links.get("quickshare_notice").getAsString();
                    }
                    throw new IOException(BST.gui_qsscreen_err_cmmn_fau_mssngUrl(additionalNote).getString(), e);
                }
                CloseableHttpResponse httpResult = HttpUtils.fetchSync((String)endpoint, (HttpUtils.FetchOptions)new HttpUtils.FetchOptions(this){

                    public final String method() {
                        return "POST";
                    }

                    public final Object body() {
                        JsonObject bodyJson = new JsonObject();
                        QuickShareScreen.addTelemetryData(bodyJson);
                        return bodyJson;
                    }
                });
                @Nullable String httpResultStr = null;
                try {
                    HttpEntity httpResultEntity = httpResult.getEntity();
                    if (httpResultEntity == null) {
                        throw new IOException("Missing HTTP response body.");
                    }
                    httpResultStr = EntityUtils.toString((HttpEntity)httpResultEntity);
                    int statusCode = httpResult.getStatusLine().getStatusCode();
                    String statusMessage = httpResult.getStatusLine().getReasonPhrase();
                    if (statusCode != 200) {
                        throw new IOException(BST.gui_qsscreen_err_upld_guu_httpN200("HTTP " + statusCode + " " + statusMessage + "\n" + httpResultStr).getString(), (Throwable)new HttpResponseException(statusCode, httpResult.getStatusLine().getReasonPhrase()));
                    }
                }
                finally {
                    IOUtils.closeQuietly((Closeable)httpResult);
                }
                JsonObject result = (JsonObject)BetterStatsWebApiUtils.GSON.fromJson(httpResultStr, JsonObject.class);
                Instant expires = null;
                try {
                    expires = Instant.parse(result.get("expires").getAsString());
                }
                catch (Exception insParseErr) {
                    expires = Instant.now().plusSeconds(30L);
                }
                return new CachedResource((Object)result, (long)httpResultStr.length(), expires);
            }

            public void onError(Exception error) {
                QuickShareUploadScreen.this.__start_onError(error);
            }

            public void onReady(JsonObject result) {
                QuickShareUploadScreen.this.__start__stage3(result);
            }
        });
    }

    @ApiStatus.Internal
    private void __start__stage3(final JsonObject uploadUrlData) {
        this.__stage = 3;
        if (!this.isOpen()) {
            return;
        }
        this.refresh();
        CachedResourceManager.getResourceAsync((class_2960)class_2960.method_60655((String)BetterStats.getModID(), (String)("quick_share/uploads/" + System.currentTimeMillis() + ".txt")), (IResourceFetchTask)new IResourceFetchTask<String>(){

            public class_1255<?> getMinecraftClientOrServer() {
                return BetterStatsClient.MC_CLIENT;
            }

            public Class<String> getResourceType() {
                return String.class;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CachedResource<String> fetchResourceSync() throws Exception {
                CachedResource cachedResource;
                String url = uploadUrlData.get("url").getAsString();
                final String method = uploadUrlData.get("method").getAsString().toUpperCase(Locale.ENGLISH);
                String filename = uploadUrlData.get("filename").getAsString();
                JsonObject fields = uploadUrlData.get("fields").getAsJsonObject();
                final BasicHeader[] headers = (BasicHeader[])uploadUrlData.get("headers").getAsJsonObject().entrySet().stream().map(entry -> new BasicHeader((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString())).toArray(BasicHeader[]::new);
                if (!Objects.equals(method, "POST")) {
                    throw new UnsupportedOperationException("BSS API server told me to perform HTTP " + method + " to upload the quick-share file, but I only support HTTP POST.");
                }
                final String multipartBoundary = "----WebKitFormBoundary@" + System.currentTimeMillis();
                final class_2540 httpBody = new class_2540(Unpooled.buffer());
                CloseableHttpResponse response = null;
                try {
                    for (Map.Entry field : fields.entrySet()) {
                        String str = "--" + multipartBoundary + "\r\nContent-Disposition: form-data; name=\"" + (String)field.getKey() + "\"\r\nContent-Type: text/plain\r\n\r\n" + ((JsonElement)field.getValue()).getAsString() + QuickShareUploadScreen.CRLF;
                        httpBody.method_52983(str.getBytes(Charsets.UTF_8));
                    }
                    Tuple2<byte[], Boolean> statsBytes = QuickShareUploadScreen.this.exportStatsBytes();
                    String str = "--" + multipartBoundary + "\r\nContent-Disposition: form-data; name=\"file\"; filename=\"" + filename + "\"\r\nContent-Type: application/octet-stream\r\nCache-Control: no-transform\r\n" + ((Boolean)statsBytes.Item2 != false ? "Content-Encoding: gzip\r\n" : "") + QuickShareUploadScreen.CRLF;
                    httpBody.method_52983(str.getBytes(Charsets.UTF_8));
                    httpBody.method_52983((byte[])statsBytes.Item1);
                    httpBody.method_52983(QuickShareUploadScreen.CRLF.getBytes(Charsets.UTF_8));
                    httpBody.method_52983(("--" + multipartBoundary + "--\r\n").getBytes(Charsets.UTF_8));
                    response = HttpUtils.fetchSync((String)url, (HttpUtils.FetchOptions)new HttpUtils.FetchOptions(){

                        public final String method() {
                            return method;
                        }

                        public final Header[] headers() {
                            return headers;
                        }

                        public final Object body() {
                            return new InputStreamEntity((InputStream)new ByteBufInputStream((ByteBuf)httpBody), ContentType.parse((String)("multipart/form-data; boundary=" + multipartBoundary)));
                        }
                    });
                    @Nullable String responseBody = "";
                    if (response.getEntity() != null) {
                        responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    }
                    int statusCode = response.getStatusLine().getStatusCode();
                    String statusReason = response.getStatusLine().getReasonPhrase();
                    if (statusCode < 200 || statusCode > 299) {
                        throw new IOException(BST.gui_qsscreen_err_upld_act_httpN200("HTTP " + statusCode + " " + statusReason + "\n" + responseBody).getString(), (Throwable)new HttpResponseException(statusCode, statusReason));
                    }
                    QuickShareUploadScreen.this.__quickShareCode = filename;
                    StringBuilder result = new StringBuilder();
                    result.append("HTTP " + method + " " + url + QuickShareUploadScreen.CRLF);
                    result.append("Response: " + statusCode + " " + statusReason + QuickShareUploadScreen.CRLF);
                    result.append("Response body:\r\n\r\n" + responseBody);
                    cachedResource = new CachedResource((Object)result.toString(), (long)result.length(), Instant.now().plus(Duration.ofDays(7L)));
                }
                catch (Throwable throwable) {
                    try {
                        httpBody.release();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (response != null) {
                        IOUtils.closeQuietly(response);
                    }
                    throw throwable;
                }
                try {
                    httpBody.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (response != null) {
                    IOUtils.closeQuietly((Closeable)response);
                }
                return cachedResource;
            }

            public void onError(Exception error) {
                QuickShareUploadScreen.this.__start_onError(error);
            }

            public void onReady(String result) {
                QuickShareUploadScreen.this.__start__stage4();
            }
        });
    }

    @ApiStatus.Internal
    private void __start__stage4() {
        this.__stage = 4;
        if (!this.isOpen()) {
            return;
        }
        this.refresh();
        BetterStats.LOGGER.info("[Quick-share] Succesfully uploaded quick-share statistics. The code is: " + this.__quickShareCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    private Tuple2<byte[], Boolean> exportStatsBytes() {
        byte[] raw = null;
        byte[] compressed = null;
        class_2540 rawBuffer = new class_2540(Unpooled.buffer());
        try {
            StatsProviderIO.write(rawBuffer, this.stats);
            raw = new byte[rawBuffer.readableBytes()];
            rawBuffer.method_52979(raw);
        }
        finally {
            rawBuffer.release();
        }
        class_2540 compressedBuffer = new class_2540(Unpooled.buffer());
        try {
            ByteBufOutputStream outputStream = new ByteBufOutputStream((ByteBuf)compressedBuffer);
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)outputStream);){
                gzipOutputStream.write(raw);
            }
            catch (IOException e) {
                throw new RuntimeException("Error during GZip compression of MCBS data", e);
            }
            compressed = new byte[compressedBuffer.readableBytes()];
            compressedBuffer.method_52979(compressed);
        }
        finally {
            compressedBuffer.release();
        }
        BetterStats.LOGGER.info("[Quick-share] Attempting to compress quick-share MCBS data using GZip. Raw file size is " + raw.length + ", and compressed file size is " + compressed.length + ".");
        if (compressed.length < raw.length) {
            return new Tuple2((Object)compressed, (Object)true);
        }
        return new Tuple2((Object)raw, (Object)false);
    }
}

